﻿Module Module1

    Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As IntPtr, ByVal wMsg As Integer, _
                                                                            ByVal wParam As Integer, ByRef lParam As Integer) As Integer

    'einfrieren und auftauen des Bildschirms
    Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwndLock As IntPtr) As IntPtr
    Private Declare Function GetDesktopWindow Lib "user32" () As IntPtr

    Private Const EM_LINEFROMCHAR As Int32 = &HC9
    Public Const vbQuote As String = """"

#Region "Bildschirm einfrieren und wieder auftauen"

    Public Sub Freeze()
        'Fenster einfrieren
        LockWindowUpdate(GetDesktopWindow)
    End Sub

    Public Sub Defrost()
        'Fenster wieder normal anzeigen
        LockWindowUpdate(0&)
    End Sub

#End Region

#Region "Such- und Ersethen-Ergebnisse"
    Public Sub InsertFindStringInListView(ByVal cRichTextBox As RichTextBox, _
                                          ByVal lpSource As String, _
                                          ByVal sSearchText As String, _
                                          ByVal cListView As ListView)
        Try
            With cRichTextBox
                If String.IsNullOrWhiteSpace(lpSource) = False And String.IsNullOrWhiteSpace(sSearchText) = False Then
                    With Form1
                        .ListViewFindResults.Items.Clear()
                        .ListViewReplaceResults.Items.Clear()
                        .ClsSliderLabel1.Text = String.Empty
                    End With
                    'für bessere Ergebnisse in Kleinbuchstaben konvertieren
                    lpSource = StrConv(lpSource, VbStrConv.Lowercase)
                    sSearchText = StrConv(sSearchText, VbStrConv.Lowercase)
                    Dim iStart As Integer = 1
                    If CBool(InStr(lpSource, sSearchText)) = True Then

                        ' Kompletten Text durchsuchen
                        Do Until CBool(InStr(iStart, lpSource, sSearchText)) = False
                            iStart = InStr(iStart, lpSource, sSearchText)
                            'Zeilen-Index ermitteln:
                            Dim iLineIndex As Integer = SendMessage(cRichTextBox.Handle, EM_LINEFROMCHAR, _
                                  iStart, 0&)
                            'entsprechend einfügen
                            With cListView
                                .Items.Add(sSearchText & " gefunden in ...")
                                .Items(.Items.Count - 1).SubItems.Add(iLineIndex + 1)
                                .Items(.Items.Count - 1).SubItems.Add(iStart - 1)
                                .Items(.Items.Count - 1).ImageIndex = 0
                            End With
                            iStart = iStart + Len(sSearchText)
                            'prüfen ob der gesuchte Text noch vorkommt
                            If CBool(InStr(iStart, lpSource, sSearchText)) = False Then Exit Do
                        Loop

                    End If 'Ende von If CBool(InStr(lpSource, SearchText)) = True Then

                    Dim iFinds As Integer = cListView.Items.Count
                    With Form1.ClsSliderLabel1
                        If Form1.TabControlTools2.SelectedIndex = 0 Then
                            If iFinds > 0 Then
                                .ForeColor = Color.Blue
                                If .Pressed = False Then
                                    .Text = sSearchText & " wurde " & iFinds & " mal gefunden, Suchergebnisse anzeigen"
                                Else
                                    .Text = sSearchText & " wurde " & iFinds & " mal gefunden"
                                End If
                            Else
                                .ForeColor = Color.Red
                                If String.IsNullOrWhiteSpace(sSearchText) = False Then
                                    .Text = sSearchText & " wurde nicht gefunden"
                                Else
                                    .Text = String.Empty
                                End If
                            End If
                        End If
                    End With
                End If 'Ende von If String.IsNullOrWhiteSpace(lpSource) = False And String.IsNullOrWhiteSpace(SearchText) = False Then
            End With

        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, "Fehler in InsertFindStringInListView")
        End Try
    End Sub

    Public Sub InsertReplaceTextInListView(ByVal cRichTextBox As RichTextBox, _
                                          ByVal sSearchText As String, _
                                          ByVal sReplaceText As String, _
                                          ByVal cListView As ListView)
        Try
            With cRichTextBox
                If String.IsNullOrWhiteSpace(sSearchText) = False And String.IsNullOrWhiteSpace(sReplaceText) = False Then
                    Dim iSelStart As Integer = .SelectionStart
                    Call Freeze()
                    With Form1
                        .ListViewFindResults.Items.Clear()
                        .ListViewReplaceResults.Items.Clear()
                        .ClsSliderLabel1.Text = String.Empty
                    End With
                    Dim iStart As Integer = 1
                    Dim lpSource As String = StrConv(.Text, VbStrConv.Lowercase)

                    ' Kompletten Text durchsuchen
                    Do Until CBool(InStr(iStart, lpSource, sSearchText)) = False
                        iStart = InStr(iStart, lpSource, sSearchText) - 1

                        .Select(iStart, Len(sSearchText))
                        .SelectedText = sReplaceText
                        lpSource = StrConv(.Text, VbStrConv.Lowercase)
                        'iStart um 1 erhöhen da sonst sRevText nicht den richtigen Wert von sReplaceText ergibt
                        iStart = iStart + 1
                        Dim sRevText As String = Mid(lpSource, iStart, Len(sReplaceText))
                        'auf Übereinstimmung prüfen
                        If CBool(StrConv(sRevText, VbStrConv.Lowercase) = StrConv(sReplaceText, VbStrConv.Lowercase)) = True Then
                            'den Wert von iStart evtl. korrigieren
                            Dim iNewRevStart As Integer = InStrRev(lpSource, sReplaceText, iStart + Len(sReplaceText) + 1)
                            If CBool(iNewRevStart > 0) = True Then
                                'iStart korrigieren
                                iStart = InStrRev(lpSource, sReplaceText, iStart + Len(sReplaceText) + 1)
                            End If
                        Else
                            Exit Do
                        End If
                        'Zeilen-Index ermitteln:
                        Dim iLineIndex As Integer = SendMessage(.Handle, EM_LINEFROMCHAR, _
                              iStart, 0&)
                        'entsprechend einfügen
                        With cListView
                            .Items.Add(sSearchText & " gefunden in ...")
                            .Items(.Items.Count - 1).SubItems.Add(iLineIndex + 1)
                            .Items(.Items.Count - 1).SubItems.Add(iStart - 1)
                            .Items(.Items.Count - 1).SubItems.Add(sReplaceText)
                            .Items(.Items.Count - 1).ImageIndex = 1
                        End With
                        'iStart um die Anzahl Zeichen von sReplaceText erhöhen,
                        'da sonst evtl. eine Endlosschleife entstehen könnte
                        iStart = iStart + Len(sReplaceText)
                        'prüfen ob der gesuchte Text noch vorkommt
                        If CBool(InStr(iStart, lpSource, sSearchText)) = False Then Exit Do
                    Loop
                    Dim iFinds As Integer = cListView.Items.Count
                    With Form1.ClsSliderLabel1
                        If Form1.TabControlTools2.SelectedIndex = 1 Then
                            If iFinds > 0 Then
                                .ForeColor = Color.Blue
                                If .Pressed = False Then
                                    .Text = vbQuote & sSearchText & vbQuote & " wurde " & iFinds & " mal gefunden und durch " & vbQuote & sReplaceText & vbQuote & " ersetzt, Ergebnisse anzeigen"
                                Else
                                    .Text = vbQuote & sSearchText & vbQuote & " wurde " & iFinds & " mal gefunden und durch" & vbQuote & sReplaceText & vbQuote & " ersetzt"
                                End If
                            Else
                                .ForeColor = Color.Red
                                If String.IsNullOrWhiteSpace(sSearchText) = False Then
                                    .Text = vbQuote & sSearchText & vbQuote & " wurde nicht gefunden"
                                Else
                                    .Text = String.Empty
                                End If
                            End If
                        End If
                    End With
                    Call Defrost()
                    .SelectionStart = iSelStart
                End If
            End With

        Catch ex As Exception
            Call Defrost()
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, "Fehler in InsertReplaceStringInListView")
        End Try
    End Sub

    Public Sub SetDefaultFindAndReplaceResults()
        Try
            With Form1
                .ListViewFindResults.Items.Clear()
                .btnGoToFirstSearchItem.Enabled = False
                .btnGoToPreviousReplaceItem.Enabled = False
                .lblCountSearchItem.Text = "{0} von {0}"
                .btnGoToNextSearchItem.Enabled = False
                .btnGoToLastSearchItem.Enabled = False
                .ListViewReplaceResults.Items.Clear()
                .btnGoToFirstReplaceItem.Enabled = False
                .btnGoToPreviousReplaceItem.Enabled = False
                .lblCountReplaceItem.Text = "{0} von {0}"
                .btnGoToNextReplaceItem.Enabled = False
                .btnGoToLastReplaceItem.Enabled = False
                .btnUndoReplace.Enabled = False
                .ClsSliderLabel1.Text = String.Empty
                'prüfen ob TabControlTools2 angezeigt wird
                If .ClsSliderLabel1.Pressed = True Then
                    'ausblenden
                    .ClsSliderLabel1.Pressed = False
                    .TabControlTools2.Visible = False
                End If
            End With
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, "Fehler in SetDefaultFindAndReplaceResults")
        End Try
    End Sub
#End Region

#Region "Text markieren"
    'diese Sub ist nicht von mir, hab leider keine Ahnung mehr woher ich sie habe (vbarchiv.net, activevb.de oder vbfun.de oder...)
    'ich entschuldige mich an dieser Stelle beim Autor dieser Sub
    ''' <summary>
    ''' Markiert den gefundenen Text (Setzt den Fokus auf die Fundstelle) 
    ''' </summary>
    ''' <param name="FindWhat">Zeichenkette oder Wort das 
    ''' gesucht werden soll</param>
    ''' <param name="MatchCase">Gibt an ob Gross-/Kleinschreibung 
    ''' berücksichtigt werden soll (False=Ignorieren)</param>
    ''' <param name="MatchWholeWord">Wenn der Wert True ist, wird nur 
    ''' nach genzen Wörtern gesucht</param>
    ''' <param name="StartFrom">Gibt die Position an ab der gesucht 
    ''' werden soll. Wenn nichts übergeben wird, wird ab der aktuellen 
    ''' Selektion gesucht</param>
    ''' <param name="bFindBackwords">Wenn der Wert True ist, wird von 
    ''' unten nach oben anstatt von Oben nach Unten gesucht</param>
    ''' <remarks>Wenn das Ende des Dokuments erreicht ist, wird wieder 
    ''' vom Anfang gesucht</remarks>
    Public Sub SelectText(ByVal FindWhat As String, _
      ByVal MatchCase As Boolean, _
      ByVal MatchWholeWord As Boolean, _
      Optional ByVal StartFrom As Integer = -1, _
      Optional ByVal bFindBackwords As Boolean = False)

        With Form1.RichTextBox1

            Dim Length As Integer = FindWhat.Length
            Dim Finds As RichTextBoxFinds
            Dim iFindPos As Integer

            ' Flags für die Suche setzen
            If MatchCase Then Finds = Finds Or RichTextBoxFinds.MatchCase
            If MatchWholeWord Then Finds = Finds Or RichTextBoxFinds.WholeWord

            ' Startposition festlegen
            If bFindBackwords = False Then
                StartFrom = .SelectionStart + .SelectionLength
            Else
                StartFrom = .SelectionStart - 1
            End If

            If bFindBackwords = False Then
                iFindPos = .Find(FindWhat, StartFrom, Finds)
            Else
                iFindPos = .Find(FindWhat, 0, StartFrom, _
                  Finds Or RichTextBoxFinds.Reverse)
            End If

            ' Wenn Ende ereicht ist, dann von Anfang an wieder suchen
            If iFindPos < 0 And StartFrom > 0 Then
                StartFrom = 0
                iFindPos = .Find(FindWhat, StartFrom, Finds)
            End If

            ' Fundstelle markieren
            If iFindPos >= 0 Then
                .Select()

                If bFindBackwords = False Then
                    .Select(.Find(FindWhat, StartFrom, Finds), Length)
                Else
                    .Select(.Find(FindWhat, 0, StartFrom, _
                      Finds Or RichTextBoxFinds.Reverse), Length)
                End If
            End If
        End With
    End Sub
#End Region

End Module
